varying vec2 uv;
uniform sampler2D tex0;

void main()
{
	
	vec2 uvs = vec2(uv[0]*1024.0, uv[1]*1024.0);

	vec2 uv_pix = vec2(floor(uvs[0]), floor(uvs[1]));

	vec2 uv_ratio = uvs - uv_pix;
	vec2 uv_ratio_inv = 1.0 - uv_ratio;
	
	float one_pix = 0.0009765625; // 1 div 1024
	
	uv_pix *= one_pix; // div 1024
	
	
	gl_FragColor = (texture2D(tex0, uv_pix) * uv_ratio_inv[0]  +  texture2D(tex0, vec2(uv_pix[0]+one_pix, uv_pix[1])) * uv_ratio[0]  ) *uv_ratio_inv[1] +
					(texture2D(tex0, vec2(uv_pix[0], uv_pix[1]+one_pix)) * uv_ratio_inv[0]  +  texture2D(tex0, vec2(uv_pix[0]+one_pix, uv_pix[1]+one_pix)) * uv_ratio[0]  ) *uv_ratio[1];

	
}
